# -*- coding: utf-8 -*-
"""Image.ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/1R20HmQS9IZ8PZ955k9R2OJeSRSvnz1m4
"""

from google.colab import drive
drive.mount('/content/drive')

import pathlib
imgdir_path = pathlib.Path('/content/drive/MyDrive/cat_dog_images')
file_list = sorted([str(path) for path in imgdir_path.glob('*.jpg')])
print(file_list)

import numpy as np
import matplotlib.pyplot as plt
import os
from PIL import Image
fig = plt.figure(figsize=(10, 5))
for i, file in enumerate(file_list):
  img = Image.open(file)
  print('Image shape:', np.array(img).shape)
  ax = fig.add_subplot(2, 3, i+1)
  ax.set_xticks([]); ax.set_yticks([])
  ax.imshow(img)
  ax.set_title(os.path.basename(file), size=15)
plt.tight_layout()
plt.show()

labels = [1 if 'dog' in os.path.basename(file) else 0 for file in file_list]
print(labels)

from torch.utils.data import Dataset
class ImageDataset(Dataset):
  def __init__(self, file_list, labels):
    self.file_list = file_list
    self.labels = labels
  def __getitem__(self, index):
    file = self.file_list[index]
    label = self.labels[index]
    return file, label
  def __len__(self):
    return len(self.labels)
image_dataset = ImageDataset(file_list, labels)
for file, label in image_dataset:
  print(file, label)

import torchvision.transforms as transforms
img_height, img_width = 80, 120
transform = transforms.Compose([transforms.ToTensor(), transforms.Resize((img_height, img_width)), ])

class ImageDataset(Dataset):
  def __init__(self, file_list, labels, transform=None):
    self.file_list = file_list
    self.labels = labels
    self.transform = transform
  def __getitem__(self, index):
    img = Image.open(self.file_list[index])
    if self.transform is not None:
      img = self.transform(img)
    label = self.labels[index]
    return img, label
  def __len__(self):
    return len(self.labels)
image_dataset = ImageDataset(file_list, labels, transform)

fig = plt.figure(figsize=(10, 6))
for i, example in enumerate(image_dataset):
  ax = fig.add_subplot(2, 3, i+1)
  ax.set_xticks([]); ax.set_yticks([])
  ax.imshow(example[0].numpy().transpose((1, 2, 0)))
  ax.set_title(f'{example[1]}', size=15)
plt.tight_layout()
plt.show()

